/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import knightminer.inspirations.library.util.TagUtil;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class TextureRecipe
extends ShapedOreRecipe {
    public final Ingredient texture;

    public TextureRecipe(ResourceLocation group, Ingredient texture, ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
        this.texture = texture;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting craftMatrix) {
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            for (ItemStack ore : this.texture.func_193365_a()) {
                ItemStack stack = craftMatrix.func_70301_a(i);
                if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)stack, (boolean)false) || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) continue;
                Block block = Block.func_149634_a((Item)this.output.func_77973_b());
                return TextureBlockUtil.createTexturedStack(block, this.output.func_77952_i(), Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
            }
        }
        return super.func_77572_b(craftMatrix);
    }

    @Nonnull
    public ItemStack func_77571_b() {
        if (this.texture.func_193365_a().length != 0 && !this.output.func_190926_b()) {
            ItemStack stack = this.texture.func_193365_a()[0];
            Block block = Block.func_149634_a((Item)this.output.func_77973_b());
            int meta = stack.func_77952_i();
            if (meta == Short.MAX_VALUE) {
                meta = 0;
            }
            return TextureBlockUtil.createTexturedStack(block, this.output.func_77952_i(), Block.func_149634_a((Item)stack.func_77973_b()), meta);
        }
        return super.func_77571_b();
    }

    public ItemStack getPlainRecipeOutput() {
        return this.output;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
            CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
            primer.width = recipe.getRecipeWidth();
            primer.height = recipe.getRecipeHeight();
            primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
            primer.input = recipe.func_192400_c();
            JsonElement elem = TagUtil.getElement(json, "texture");
            return new TextureRecipe(recipe.func_193358_e().isEmpty() ? null : new ResourceLocation(recipe.func_193358_e()), CraftingHelper.getIngredient((JsonElement)elem, (JsonContext)context), recipe.func_77571_b(), primer);
        }
    }
}

